package ru.yandex.chemodan.app.djfs.core.album;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.djfs.core.ActionContext;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourceId;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.CompoundReschedulePolicy;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleExponential;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public abstract class FileOperationBaseProcessingTask extends AlbumBaseProcessingTask {
    private static final Logger logger = LoggerFactory.getLogger(FileOperationBaseProcessingTask.class);

    protected final GeoAlbumManager geoAlbumManager;
    protected final PersonalAlbumManager personalAlbumManager;

    public FileOperationBaseProcessingTask(GeoAlbumManager geoAlbumManager,
                                           PersonalAlbumManager personalAlbumManager)
    {
        super();
        this.geoAlbumManager = geoAlbumManager;
        this.personalAlbumManager = personalAlbumManager;
    }

    public FileOperationBaseProcessingTask(String uid, String resourceId) {
        super(uid, resourceId);
        this.geoAlbumManager = null;
        this.personalAlbumManager = null;
    }

    @Override
    public void doExecute(Parameters parameters, ExecutionContext context) {

        DjfsUid uid = DjfsUid.cons(parameters.getUid(), ActionContext.CLIENT_INPUT);
        DjfsResourceId resourceId = DjfsResourceId.cons(parameters.getResourceId(), ActionContext.CLIENT_INPUT);

        if (!uid.equals(resourceId.getUid())) {
            logger.info("File operation is asked for file with different uid (user: " + uid.asString() +
                    ", resource_id: " + resourceId.getValue() + ")");
            return;
        }

        processResource(Cf.list(resourceId));

    }

    protected abstract void processResource(ListF<DjfsResourceId> resourceIds);

    @Override
    public TaskQueueName queueName() {
        return TaskQueueName.REGULAR; // queue never used
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardSeconds(100);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new CompoundReschedulePolicy(
                new RescheduleConstant(Duration.standardMinutes(1), 10),
                new RescheduleExponential(Duration.standardMinutes(1), 10)
        );
    }
}
