package ru.yandex.chemodan.app.djfs.core.album;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourceId;
import ru.yandex.commune.dynproperties.DynamicProperty;

public class FileOperationPostProcessingTask extends FileOperationBaseProcessingTask {

    private final DynamicProperty<Boolean> enablePersonalCleaning = new DynamicProperty<>(
            "disk-djfs-albums-enable-clean-personal", false);

    public FileOperationPostProcessingTask(GeoAlbumManager geoAlbumManager,
                                           PersonalAlbumManager personalAlbumManager)
    {
        super(geoAlbumManager, personalAlbumManager);
    }

    public FileOperationPostProcessingTask(String uid, String resourceId) {
        super(uid, resourceId);
    }

    @Override
    protected void processResource(ListF<DjfsResourceId> resourceIds) {
        geoAlbumManager.postProcessFiles(resourceIds);
        if (enablePersonalCleaning.get()) {
            personalAlbumManager.postProcessFiles(resourceIds);
        }
    }
}
