package ru.yandex.chemodan.app.djfs.core.album;

import javax.annotation.Nullable;

import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.djfs.core.tasks.DjfsAlbumsTaskQueueName;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.bazinga.YcridOnetimeTaskSupport;
import ru.yandex.chemodan.bazinga.YcridTaskParameters;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class GenerateGeoAlbumsTask extends YcridOnetimeTaskSupport<GenerateGeoAlbumsTask.Parameters> {

    private GeoAlbumManager geoAlbumManager;

    public GenerateGeoAlbumsTask(long uid) {
        super(new Parameters(uid));
        this.geoAlbumManager = null;
    }

    public GenerateGeoAlbumsTask(Parameters parameters) {
        super(parameters);
        this.geoAlbumManager = null;
    }

    public GenerateGeoAlbumsTask(GeoAlbumManager geoAlbumManager) {
        super(Parameters.class);
        this.geoAlbumManager = geoAlbumManager;
    }

    @Override
    protected void doExecute(Parameters parameters, ExecutionContext context) {
        geoAlbumManager.generateGeoAlbumsForUser(DjfsUid.cons(parameters.getUid()));
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardDays(1);
    }

    @Override
    public TaskQueueName queueName() {
        return DjfsAlbumsTaskQueueName.ALBUMS_GEO_GENERATION_TASKS;
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return Parameters.Converter.class;
    }

    @Data
    @BenderBindAllFields
    public static class Parameters extends YcridTaskParameters {
        private final long uid;

        public static class Converter implements ActiveUniqueIdentifierConverter<Parameters, Parameters> {
            @Override
            public Class<Parameters> getActiveUniqueIdentifierClass() {
                return Parameters.class;
            }

            @Override
            public Parameters convert(Parameters parameters) {
                return parameters;
            }
        }
    }
}
