package ru.yandex.chemodan.app.djfs.core.album;

import ru.yandex.chemodan.app.djfs.core.db.pg.TransactionUtils;
import ru.yandex.chemodan.app.djfs.core.filesystem.Filesystem;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FileDjfsResource;

public class GeoAlbumResourceProcessingTask extends GeoAlbumBaseProcessingTask {
    public GeoAlbumResourceProcessingTask(Filesystem filesystem, GeoAlbumManager geoAlbumManager,
            TransactionUtils transactionUtils)
    {
        super(filesystem, geoAlbumManager, transactionUtils);
    }

    public GeoAlbumResourceProcessingTask(String uid, String resourceId) {
        super(uid, resourceId);
    }

    @Override
    protected void processResource(FileDjfsResource file, GeoInfo geoInfo) {
        geoAlbumManager.addPhotoToAlbum(file, geoInfo);
    }
}
