package ru.yandex.chemodan.app.djfs.core.album;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.inside.geobase.Geobase;
import ru.yandex.inside.geobase.RegionType;

public class NativeCityStrategy extends DefaultCityStrategy {
    private final SetF<Integer> bigCityGeoIds = Cf.set(
            213  // MOSCOW
    );

    private final int cityGeoId;

    public NativeCityStrategy(Geobase geobase, int cityGeoId) {
        super(geobase);
        this.cityGeoId = cityGeoId;
    }


    @Override
    protected MapF<RegionType, Integer> getRegionSpecificIds(MapF<RegionType, Integer> allRegions) {
        if (!allRegions.getO(RegionType.CITY).isPresent()) {
            return Cf.map();
        }

        if (!allRegions.getOrThrow(RegionType.CITY).equals(cityGeoId)) {
            return Cf.map();
        }

        if (bigCityGeoIds.containsTs(cityGeoId)) {
            if (allRegions.containsKeyTs(RegionType.CITY_MICRODISTRICT)) {
                return Cf.map(RegionType.CITY_MICRODISTRICT, allRegions.getOrThrow(RegionType.CITY_MICRODISTRICT));
            }
            return Cf.map();
        }

        if (allRegions.containsKeyTs(RegionType.CITY_DISTRICT)) {
            return Cf.map(RegionType.CITY_DISTRICT, allRegions.getOrThrow(RegionType.CITY_DISTRICT));
        }

        return Cf.map();
    }
}
