package ru.yandex.chemodan.app.djfs.core.album;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.inside.geobase.Geobase;
import ru.yandex.inside.geobase.RegionType;

public class NativeSettlementStrategy extends DefaultCityStrategy {
    private final int settlementGeoId;

    public NativeSettlementStrategy(Geobase geobase, int settlementGeoId) {
        super(geobase);
        this.settlementGeoId = settlementGeoId;
    }

    @Override
    protected MapF<RegionType, Integer> getRegionSpecificIds(MapF<RegionType, Integer> allRegions) {
        if (!allRegions.getO(RegionType.SETTLEMENT).isPresent()) {
            return Cf.map();
        }

        if (!allRegions.getOrThrow(RegionType.SETTLEMENT).equals(settlementGeoId)) {
            return Cf.map();
        }

        return Cf.map(RegionType.SETTLEMENT, allRegions.getOrThrow(RegionType.SETTLEMENT));
    }
}
