package ru.yandex.chemodan.app.djfs.core.album;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.inside.geobase.Geobase;
import ru.yandex.inside.geobase.RegionType;

public class NativeVillageStrategy extends DefaultCityStrategy {
    private final int villageGeoId;

    public NativeVillageStrategy(Geobase geobase, int villageGeoId) {
        super(geobase);
        this.villageGeoId = villageGeoId;
    }

    @Override
    protected MapF<RegionType, Integer> getRegionSpecificIds(MapF<RegionType, Integer> allRegions) {
        if (!allRegions.getO(RegionType.VILLAGE).isPresent()) {
            return Cf.map();
        }

        if (!allRegions.getOrThrow(RegionType.VILLAGE).equals(villageGeoId)) {
            return Cf.map();
        }

        return Cf.map(RegionType.VILLAGE, allRegions.getOrThrow(RegionType.VILLAGE));
    }
}
