package ru.yandex.chemodan.app.djfs.core.album;

import org.bson.types.ObjectId;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDao;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.db.pg.ResultSetUtils;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

public class PgAlbumFaceClustersDao extends PgShardedDao implements AlbumFaceClustersDao {
    public PgAlbumFaceClustersDao(PgShardedDaoContext context) {
        super(context);
    }

    @Override
    public void insert(DjfsUid uid, ObjectId albumId, String clusterId) {
        String sql =
            collectStats(uid)
            + " INSERT INTO disk.album_face_clusters (uid, album_id, cluster_id) VALUES (:uid, :album_id, :cluster_id)";
        MapF<String, Object> params =
            Cf.toMap(Tuple2List.fromPairs(
                "uid", uid,
                "album_id", albumId.toByteArray(),
                "cluster_id", clusterId
            ));
        jdbcTemplate(uid).update(sql, params);
    }

    @Override
    public ListF<String> getClusters(DjfsUid uid, ObjectId albumId) {
        String sql =
            collectStats(uid)
            + " SELECT cluster_id FROM disk.album_face_clusters WHERE uid = :uid AND album_id = :album_id";
        return
            jdbcTemplate(uid)
            .query(
                sql,
                (rs, rowNum) -> ResultSetUtils.getStringO(rs, "cluster_id").get(),
                Cf.map("uid", uid, "album_id", albumId.toByteArray())
            );
    }

    @Override
    public void deleteAll(DjfsUid uid) {
        String sql = collectStats(uid) + " DELETE FROM disk.album_face_clusters WHERE uid = :uid";
        jdbcTemplate(uid).update(sql, Cf.map("uid", uid));
    }

    @Override
    public void deleteAll(DjfsUid uid, ObjectId albumId) {
        String sql = collectStats(uid) + " DELETE FROM disk.album_face_clusters WHERE uid = :uid AND id = :album_id";
        jdbcTemplate(uid).update(sql, Cf.map("uid", uid, "album_id", albumId.toByteArray()));
    }

    @Override
    public int changeAlbumId(DjfsUid uid, ObjectId srcAlbumId, ObjectId dstAlbumId) {
        String query = collectStats(uid)
                + " UPDATE disk.album_face_clusters SET album_id = :dst_album_id"
                + " WHERE uid = :uid AND album_id = :src_album_id";
        return jdbcTemplate(uid).update(query,
                Cf.map("uid", uid, "src_album_id", srcAlbumId.toByteArray(), "dst_album_id", dstAlbumId.toByteArray()));
    }

    @Override
    public Option<ObjectId> getAlbum(DjfsUid uid, String clusterId) {
        String sql = collectStats(uid)
                + " SELECT album_id FROM disk.album_face_clusters WHERE uid = ? AND cluster_id = ?";
        return jdbcTemplate(uid)
                .queryForOption(sql, String.class, uid, clusterId)
                .map(s -> new ObjectId(s.substring(2) /* drop leading \x */));
    }
}
