package ru.yandex.chemodan.app.djfs.core.album;

import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;


public class RawJsonValueSerializer {
    public static ToFieldMarshallerSupport consMarshaller() {
        return new ToFieldMarshallerSupport() {
            @Override
            public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
                writeJson(writer, fieldValue);
            }

            protected void writeJson(BenderJsonWriter json, Object o) {
                RawJsonValueSerializer.writeJson(json, (RawJsonValue) o);
            }
        };
    }

    public static void writeJson(BenderJsonWriter json, RawJsonValue field) {
        json.writeRawValue(field.value);
    }

    private RawJsonValueSerializer() {}
}
