package ru.yandex.chemodan.app.djfs.core.album;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.SafeCloseable;
import ru.yandex.misc.ThreadLocalX;

/**
 * @author yak-dmitriy
 */
public class SynchronizedHandlerHolder {
    private static final ThreadLocalX<Boolean> isSynchronizedHandler = new ThreadLocalX<>();

    public static Option<Boolean> getO() {
        return isSynchronizedHandler.getO();
    }

    public static Boolean get() {
        return isSynchronizedHandler.getO().isPresent() && isSynchronizedHandler.getO().get();
    }

    public static SafeCloseable set(Boolean isSynchronizedHandler) {
        SynchronizedHandlerHolder.isSynchronizedHandler.set(isSynchronizedHandler);
        return SynchronizedHandlerHolder::remove;
    }

    public static SafeCloseable set(Option<Boolean> isSynchronizedHandlerO) {
        if (isSynchronizedHandlerO.isPresent()) {
            set(isSynchronizedHandlerO.get());
        } else {
            remove();
        }
        return SynchronizedHandlerHolder::remove;
    }

    public static void remove() {
        isSynchronizedHandler.remove();
    }
}
