package ru.yandex.chemodan.app.djfs.core.album;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;

/**
 * @author yak-dmitriy
 */
public class SynchronizedToAlbumLockedInterceptor implements ActionInvocationInterceptor {
    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        if (Option.ofNullable(invocation.getActionDescriptor().hasAnnotation(SynchronizedToAlbumLocked.class)).isPresent()) {
            SynchronizedHandlerHolder.set(true);
            try {
                return invocation.invoke();
            } finally {
                SynchronizedHandlerHolder.remove();
            }
        }
        return invocation.invoke();
    }

    @Override
    public int getOrder() { return 2; }
}
