package ru.yandex.chemodan.app.djfs.core.album;

import lombok.Value;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.djfs.core.tasks.DjfsAlbumsTaskQueueName;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.bazinga.YcridOnetimeTaskSupport;
import ru.yandex.chemodan.bazinga.YcridTaskParameters;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class UpdateUserFacesTask extends YcridOnetimeTaskSupport<UpdateUserFacesTask.Parameters> {
    @BenderBindAllFields
    @Value
    static class Parameters extends YcridTaskParameters {
        DjfsUid uid;
    }

    private final FacesAlbumManager facesAlbumManager;

    // for schedule
    public UpdateUserFacesTask(DjfsUid uid) {
        super(new Parameters(uid));
        this.facesAlbumManager = null;
    }

    // for execute
    public UpdateUserFacesTask(FacesAlbumManager facesAlbumManager) {
        super(Parameters.class);
        this.facesAlbumManager = facesAlbumManager;
    }

    @Override
    protected void doExecute(Parameters parameters, ExecutionContext context) {
        facesAlbumManager.updateAlbumsFromClusters(parameters.uid);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardDays(1);
    }

    @Override
    public TaskQueueName queueName() {
        return DjfsAlbumsTaskQueueName.ALBUMS_UPDATE_USER_FACES_TASKS;
    }
}
