package ru.yandex.chemodan.app.djfs.core.album;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.misc.io.http.HttpStatus;

public class UserRefusedException extends DjfsException implements HttpStatusCodeSource {
    public UserRefusedException(DjfsUid uid) {
        super("User " + uid.asString() + " opted out from the feature");
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_410_GONE;
    }
}
