package ru.yandex.chemodan.app.djfs.core.album.operation.albummerge;

import org.bson.types.ObjectId;

import ru.yandex.chemodan.app.djfs.core.album.AlbumType;
import ru.yandex.chemodan.app.djfs.core.operations.Operation;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author yashunsky
 */
public class AlbumMergeOperation {
    public static final String TYPE = "albums_merge";
    public static final String SUBTYPE = "albums_merge";

    public static Operation create(DjfsUid uid, ObjectId srcAlbumId, ObjectId dstAlbumId, AlbumType type) {
        AlbumMergeOperationData data = new AlbumMergeOperationData(srcAlbumId, dstAlbumId, type);
        return Operation.cons(uid, TYPE, SUBTYPE, data, AlbumMergeOperationData.B);
    }
}
