package ru.yandex.chemodan.app.djfs.core.album.operation.albummerge;

import lombok.Data;
import org.bson.types.ObjectId;
import org.joda.time.Duration;

import ru.yandex.bolts.function.Function0V;
import ru.yandex.chemodan.app.djfs.core.album.AlbumMergeManager;
import ru.yandex.chemodan.app.djfs.core.album.AlbumType;
import ru.yandex.chemodan.app.djfs.core.operations.MpfsOperationHandler;
import ru.yandex.chemodan.app.djfs.core.operations.OperationDao;
import ru.yandex.chemodan.app.djfs.core.tasks.DjfsAlbumsTaskQueueName;
import ru.yandex.chemodan.app.djfs.core.tasks.DjfsOperationTaskParameters;
import ru.yandex.chemodan.app.djfs.core.tasks.DjfsOperationTaskSupport;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.bazinga.YcridTaskParameters;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author yashunsky
 */
public class AlbumMergeTask extends DjfsOperationTaskSupport<AlbumMergeTask.Parameters> {
    private static final Logger logger = LoggerFactory.getLogger(AlbumMergeTask.class);

    private final AlbumMergeManager albumMergeManager;

    public AlbumMergeTask(AlbumMergeManager albumMergeManager, OperationDao operationDao) {
        super(Parameters.class, operationDao);
        this.albumMergeManager = albumMergeManager;
    }

    public AlbumMergeTask(DjfsUid uid, String oid, ObjectId source, ObjectId destination, AlbumType type) {
        super(new Parameters(uid, oid, source, destination, type));
        this.albumMergeManager = null;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @Override
    public TaskQueueName queueName() {
        return DjfsAlbumsTaskQueueName.ALBUMS_MERGE_TASKS;
    }

    @Override
    protected MpfsOperationHandler.Status executeInner(Parameters parameters, ExecutionContext context) {
        Function0V handler;

        DjfsUid uid = parameters.getUid();
        ObjectId source = parameters.getSource();
        ObjectId destination = parameters.getDestination();
        AlbumType type = parameters.getType();

        switch (type) {
            case FACES:
                handler = () -> albumMergeManager.mergeFaceAlbums(uid, source, destination);
                break;
            default:
                logger.error("Merge not supported for album type {}", type);
                return MpfsOperationHandler.Status.FAIL;
        }

        logger.info("Merging items for user {} from {} to {}", uid, source, destination);

        handler.apply();
        return MpfsOperationHandler.Status.DONE;
    }

    @Data
    @BenderBindAllFields
    public static class Parameters extends YcridTaskParameters implements DjfsOperationTaskParameters {
        private final DjfsUid uid;
        private final String oid;
        private final ObjectId source;
        private final ObjectId destination;
        private final AlbumType type;
    }
}
