package ru.yandex.chemodan.app.djfs.core.album.pojo;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.album.Album;
import ru.yandex.chemodan.app.djfs.core.album.AlbumItem;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.ResourcePojo;
import ru.yandex.chemodan.app.djfs.core.util.InstantUtils;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;


@BenderBindAllFields
@AllArgsConstructor
public class AlbumItemPojo {
    public final String id;
    @BenderPart(name = "date_created", strictName = true)
    public final Option<Long> ctime;
    @BenderPart(name = "order_index", strictName = true)
    public final Option<Double> orderIndex;
    @BenderPart(name = "album_id", strictName = true)
    public final String albumId;
    @BenderPart(name = "obj_id", strictName = true)
    public final String objectId;
    public final String uid;
    public final ResourcePojo object;
    @BenderPart(name = "obj_type", strictName = true)
    public final String objectType;

    @BenderPart(name = "face_left", strictName = true)
    public final Option<Double> faceLeft;
    @BenderPart(name = "face_top", strictName = true)
    public final Option<Double> faceTop;
    @BenderPart(name = "face_right", strictName = true)
    public final Option<Double> faceRight;
    @BenderPart(name = "face_bottom", strictName = true)
    public final Option<Double> faceBottom;
    public final Option<Integer> width;
    public final Option<Integer> height;

    public static AlbumItemPojo fromResource(AlbumItem item, ResourcePojo resourcePojo, Album album) {
        return new AlbumItemPojo(
                item.getId().toHexString(),
                item.getDateCreated().map(InstantUtils::toSecondsHalfDown),
                item.getOrderIndex(),
                album.getId().toHexString(),
                item.getObjectId(),
                item.getUid().toString(),
                resourcePojo,
                resourcePojo.type,
                item.getFaceInfo().map(x -> x.getCoordinates().getLeftTopAngle().getX()),
                item.getFaceInfo().map(x -> x.getCoordinates().getLeftTopAngle().getY()),
                item.getFaceInfo().map(x -> x.getCoordinates().getRightBottomAngle().getX()),
                item.getFaceInfo().map(x -> x.getCoordinates().getRightBottomAngle().getY()),
                item.getFaceInfo().map(x -> x.getWidth()),
                item.getFaceInfo().map(x -> x.getHeight())
        );
    }
}
