package ru.yandex.chemodan.app.djfs.core.album.pojo;

import lombok.AllArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.album.Album;
import ru.yandex.chemodan.app.djfs.core.album.AlbumLayoutType;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResource;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.UserPojo;
import ru.yandex.chemodan.app.djfs.core.util.InstantUtils;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

@BenderBindAllFields
@AllArgsConstructor
@ActionResultPojo
public class AlbumPojo {
    private final String id;
    @BenderPart(name = "fotki_album_id", strictName = true)
    private final Option<Long> fotkiAlbumId;
    private final String uid;
    private final UserPojo user;

    @BenderPart(name = "album_type", strictName = true)
    private final String type;
    private final String title;
    private final String layout;

    @BenderPart(name = "is_blocked", strictName = true)
    private final Boolean isBlocked;
    @BenderPart(name = "is_empty", strictName = true)
    private final Boolean isEmpty;
    @BenderPart(name = "is_public", strictName = true)
    private final Boolean isPublic;

    @BenderPart(name = "ctime", strictName = true)
    private final Option<Long> dateCreated;
    @BenderPart(name = "mtime", strictName = true)
    private final Option<Long> dateModified;

    @BenderPart(name = "public", strictName = true)
    private final AlbumPublicPojo publicInfo;

    @BenderPart(name = "is_desc_sorting", strictName = true)
    private final Option<Boolean> isDescSorting;
    @BenderPart(name = "album_items_sorting", strictName = true)
    private final Option<String> ItemsSortingMethod;

    private final Option<AlbumItemPojo> cover;
    @BenderPart(name = "social_cover_stid", strictName = true)
    private final Option<String> socialCoverStid;
    @BenderPart(name = "social_cover_url", strictName = true)
    private final Option<String> socialCoverUrl;


    public static AlbumPojo fromAlbum(Album album, UserPojo userPojo, Option<AlbumItemPojo> coverItemPojo,
                                      boolean isEmpty, Option<DjfsResource> cover, MpfsClient mpfsClient) {
        Option<Instant> actualTime = album.getDateCreated().orElse(album.getDateModified());
        return new AlbumPojo(
                album.getId().toHexString(),
                album.getFotkiAlbumId(),
                album.getUid().toString(),
                userPojo,
                album.getType().value(),
                album.getTitle(),
                album.getLayout().map(AlbumLayoutType::value).getOrElse(""),
                album.isBlocked(),
                isEmpty,
                album.isPublic(),
                album.getDateCreated().orElse(actualTime).map(InstantUtils::toSecondsHalfDown),
                album.getDateModified().orElse(actualTime).map(InstantUtils::toSecondsHalfDown),
                AlbumPublicPojo.fromAlbum(album),
                album.getIsDescSorting(),
                album.getAlbumItemsSorting(),
                coverItemPojo,
                album.getSocialCoverStid(),
                cover.isPresent() ? album.getSocialCoverStid().map(socialCoverStid ->
                        mpfsClient.generateZaberunUrl(
                                socialCoverStid,
                                cover.get().getDisplayName(),
                                "preview",
                                Option.of(album.getUid().toString()),
                                Option.empty(), Option.empty(), Option.empty(),
                                Option.empty(), Option.empty(), Option.empty(),
                                Option.of("1200x630"),
                                Option.empty(), Option.empty(), Option.empty(),
                                Option.empty(), Option.of(true), Option.of(true)
                )) : Option.empty()
        );
    }
}


