package ru.yandex.chemodan.app.djfs.core.album.pojo;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.album.Album;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

@BenderBindAllFields
@AllArgsConstructor
public class AlbumPublicPojo {
    @BenderPart(name = "short_url", strictName = true)
    public final Option<String> shortUrl;
    @BenderPart(name = "public_url", strictName = true)
    public final Option<String> publicUrl;
    @BenderPart(name = "views_count", strictName = true)
    public final int viewsCount;
    @BenderPart(name = "publicKey", strictName = true)
    public final Option<String> publicKey;

    public static AlbumPublicPojo fromAlbum(Album album) {
        return new AlbumPublicPojo(
                album.getShortUrl(),
                album.getPublicUrl(),
                0,
                album.getPublicKey()
        );
    }
}

