package ru.yandex.chemodan.app.djfs.core.album.pojo;


import lombok.RequiredArgsConstructor;
import org.joda.time.Instant;
import org.junit.Assume;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.djfs.core.album.AlbumItem;
import ru.yandex.chemodan.app.djfs.core.album.CollectionId;
import ru.yandex.chemodan.app.djfs.core.album.ExtendedAlbum;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

@ActionResultPojo
@BenderBindAllFields
@RequiredArgsConstructor
public class AlbumSnapshotPojo {
    public final String handle;

    @BenderPart(name = "records_count", strictName = true)
    public final int recordsCount;
    public final Instant created;
    public final Instant modified;

    @BenderPart(name = "database_id", strictName = true)
    public final String databaseId;

    public final long revision;
    public final long size;

    public final AlbumSnapshotRecordsPojo records;

    public static AlbumSnapshotPojo consForAlbums(ListF<ExtendedAlbum> albumsWithMeta, Option<Long> albumsRevision) {
        Assume.assumeTrue(albumsWithMeta.isNotEmpty());

        Long maxRevision = albumsRevision.isPresent() ? albumsRevision.get() :
                albumsWithMeta.map(x -> x.album.getRevision().getOrElse(0L)).max();
        Instant ctime = albumsWithMeta.map(x -> x.album.getDateCreated().getOrElse(new Instant(0))).min();
        Instant mtime = albumsWithMeta.map(x -> x.album.getDateModified().getOrElse(new Instant(0))).max();

        return new AlbumSnapshotPojo(
                "0",
                albumsWithMeta.length(),
                ctime,
                mtime,
                CollectionId.formatAlbumsDatabaseId(),
                maxRevision,
                0,
                AlbumSnapshotRecordsPojo.consForAlbums(albumsWithMeta)
        );
    }

    public static AlbumSnapshotPojo consForItems(ListF<AlbumItem> albumItems, Tuple2List<String, DjfsUid> gidToOwner) {
        return new AlbumSnapshotPojo(
                "0",
                albumItems.length(),
                new Instant(0),
                new Instant(0),
                CollectionId.formatAlbumsDatabaseId(),
                0,
                0,
                AlbumSnapshotRecordsPojo.consForItems(albumItems, gidToOwner)
        );
    }
}
