package ru.yandex.chemodan.app.djfs.core.album.pojo;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.djfs.core.album.Album;
import ru.yandex.chemodan.app.djfs.core.album.AlbumItem;
import ru.yandex.chemodan.app.djfs.core.album.AlbumItemField;
import ru.yandex.chemodan.app.djfs.core.album.AlbumUtils;
import ru.yandex.chemodan.app.djfs.core.album.CollectionId;
import ru.yandex.chemodan.app.djfs.core.album.ExtendedAlbum;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

@BenderBindAllFields
public class AlbumSnapshotRecordsItemPojo {
    @BenderPart(name = "record_id", strictName = true)
    public final String recordId;
    @BenderPart(name = "collection_id", strictName = true)
    public final String collectionId;
    public final long revision;
    public final ListF<AlbumItemField> fields;

    public AlbumSnapshotRecordsItemPojo(ExtendedAlbum albumWithMeta) {
        Album album = albumWithMeta.album;

        recordId = CollectionId.formatAlbumCollectionId(album);
        collectionId = CollectionId.ALBUM_LIST_COLLECTION_ID;
        revision = album.getRevision().getOrElse(0L);

        fields = AlbumUtils.generateAllFields(album, albumWithMeta.itemsCount, albumWithMeta.coverResourceId);
    }

    public AlbumSnapshotRecordsItemPojo(AlbumItem albumItem, DjfsUid resourceOwner) {
        recordId = albumItem.getId().toHexString();
        collectionId = CollectionId.formatAlbumCollectionId(albumItem.getAlbumId());
        revision = 0;
        fields = AlbumUtils.generateAllFields(albumItem, resourceOwner);
    }
}
