package ru.yandex.chemodan.app.djfs.core.album.pojo;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.djfs.core.album.AlbumItem;
import ru.yandex.chemodan.app.djfs.core.album.AlbumItemType;
import ru.yandex.chemodan.app.djfs.core.album.ExtendedAlbum;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@BenderBindAllFields
@RequiredArgsConstructor
public class AlbumSnapshotRecordsPojo {
    public final ListF<AlbumSnapshotRecordsItemPojo> items;

    public static AlbumSnapshotRecordsPojo consForAlbums(ListF<ExtendedAlbum> albumsWithMeta) {
        return new AlbumSnapshotRecordsPojo(
                albumsWithMeta.map(AlbumSnapshotRecordsItemPojo::new)
        );
    }

    public static AlbumSnapshotRecordsPojo consForItems(ListF<AlbumItem> albumItems,
                                                        Tuple2List<String, DjfsUid> gidToOwner)
    {
        MapF<String, DjfsUid> gid2Owner = gidToOwner.toMap();

        ListF<AlbumSnapshotRecordsItemPojo> itemPojos = Cf.arrayListWithCapacity(albumItems.length());
        for (AlbumItem item : albumItems) {
            DjfsUid resourceOwner = item.getUid();
            if (item.getObjectType().equals(AlbumItemType.SHARED_RESOURCE) && item.getGroupId().isPresent()) {
                resourceOwner = gid2Owner.getOrElse(item.getGroupId().get(), item.getUid());
            }
            itemPojos.add(new AlbumSnapshotRecordsItemPojo(item, resourceOwner));
        }

        return new AlbumSnapshotRecordsPojo(itemPojos);
    }
}
