package ru.yandex.chemodan.app.djfs.core.album.worker;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.djfs.core.index.BazingaManagerProperties;
import ru.yandex.chemodan.app.djfs.core.tasks.DjfsAlbumsTaskQueueName;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.bazinga.YcridOnetimeTaskSupport;
import ru.yandex.chemodan.bazinga.YcridTaskParameters;
import ru.yandex.chemodan.util.retry.RetryManager;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yak-dmitriy
 */
public class DjfsAlbumsQueueWatchdogTask extends YcridOnetimeTaskSupport<DjfsAlbumsQueueWatchdogTask.Parameters> {

    private final DjfsAlbumsTaskDao djfsAlbumsTaskDao;

    private final BazingaTaskManager bazingaTaskManager;
    private final BazingaManagerProperties bazingaTaskManagerProperties;

    public DjfsAlbumsQueueWatchdogTask(DjfsAlbumsTaskDao djfsAlbumsTaskDao,
            BazingaTaskManager bazingaTaskManager, BazingaManagerProperties bazingaTaskManagerProperties) {
        super(Parameters.class);
        this.djfsAlbumsTaskDao = djfsAlbumsTaskDao;
        this.bazingaTaskManager = bazingaTaskManager;
        this.bazingaTaskManagerProperties = bazingaTaskManagerProperties;
    }

    public DjfsAlbumsQueueWatchdogTask(String uid) {
        super(new Parameters(uid));
        this.djfsAlbumsTaskDao = null;
        this.bazingaTaskManager = null;
        this.bazingaTaskManagerProperties = null;
    }

    @Override
    protected void doExecute(Parameters parameters, ExecutionContext context) {
        if (!djfsAlbumsTaskDao.getSubtasks(DjfsUid.cons(parameters.uid), 1).isEmpty()) {
            scheduleQueueTask(parameters.uid);
        }
    }

    private void scheduleQueueTask(String uid) {
        new RetryManager().withRetryPolicy(
                bazingaTaskManagerProperties.getMaxRetries(),
                bazingaTaskManagerProperties.getRetryDelayMillis()
        ).run(() ->
                bazingaTaskManager.schedule(
                        new DjfsAlbumsQueueTask(uid)
                )
        );
    }

    @Override
    public TaskQueueName queueName() {
        return DjfsAlbumsTaskQueueName.ALBUMS_QUEUE_TASKS;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardSeconds(100);
    }

    @BenderBindAllFields
    static class Parameters extends YcridTaskParameters {
        private final String uid;

        Parameters(String uid) {
            this.uid = uid;
        }
    }

}
