package ru.yandex.chemodan.app.djfs.core.album.worker;

import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.album.AlbumBaseProcessingTask;
import ru.yandex.chemodan.app.djfs.core.album.GeoAlbumBaseProcessingTask;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.misc.lang.Validate;

/**
 * @author yak-dmitriy
 */
public class DjfsAlbumsSubtask {

    UUID id = null;
    DjfsUid uid;
    String taskId;
    Option<GeoAlbumBaseProcessingTask.Parameters> parameters;
    Integer retryCount;
    Instant nextSchedule;

    public DjfsAlbumsSubtask(UUID id, DjfsUid uid, String taskId, AlbumBaseProcessingTask.Parameters parameters,
            Integer retryCount, Instant nextSchedule) {
        Validate.notNull(parameters, "parameters cannot be null");
        this.id = id;
        this.uid = uid;
        this.taskId = taskId;
        this.parameters = Option.of(parameters);
        this.retryCount = retryCount;
        this.nextSchedule = nextSchedule;
    }

    public DjfsAlbumsSubtask(DjfsUid uid, String taskId, AlbumBaseProcessingTask.Parameters parameters) {
        Validate.notNull(parameters, "parameters cannot be null");
        this.uid = uid;
        this.taskId = taskId;
        this.parameters = Option.of(parameters);
        this.retryCount = 0;
        this.nextSchedule = Instant.now();
    }

    public DjfsAlbumsSubtask(DjfsUid uid, String taskId, String resourceId) {
        this.uid = uid;
        this.taskId = taskId;
        this.parameters = Option.of(AlbumBaseProcessingTask.Parameters.getParameters(uid.asString(), resourceId));
        this.retryCount = 0;
        this.nextSchedule = Instant.now();
    }

    public final UUID getId() {
        return id;
    }

    public final DjfsUid getUid() {
        return uid;
    }

    public final String getTaskId() {
        return taskId;
    }

    public final AlbumBaseProcessingTask.Parameters getParameters() {
        return parameters.getOrThrow("DjfsAlbumsSubtask.parameters is not initialized");
    }

    public final Integer getRetryCount() {
        return retryCount;
    }

    public final Instant getNextSchedule() {
        return nextSchedule;
    }

}
