package ru.yandex.chemodan.app.djfs.core.album.worker;

import ru.yandex.chemodan.app.djfs.core.album.AlbumBaseProcessingTask;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.util.retry.RetryManager;
import ru.yandex.commune.bazinga.BazingaTaskManager;

/**
 * @author yak-dmitriy
 */
public class DjfsAlbumsTaskManager {

    private final BazingaTaskManager bazingaTaskManager;
    private final DjfsAlbumsTaskDao djfsAlbumsTaskDao;

    public DjfsAlbumsTaskManager(BazingaTaskManager bazingaTaskManager, DjfsAlbumsTaskDao djfsAlbumsTaskDao) {
        this.bazingaTaskManager = bazingaTaskManager;
        this.djfsAlbumsTaskDao = djfsAlbumsTaskDao;
    }

    public void schedule(AlbumBaseProcessingTask task) {
        setTask(task);
    }

    public void schedule(AlbumBaseProcessingTask task, int maxRetries, long delayInMillis) {
        new RetryManager().withRetryPolicy(
                maxRetries,
                delayInMillis
        ).run(() ->
                setTask(task)
        );
    }

    private void setTask(AlbumBaseProcessingTask task) {

        AlbumBaseProcessingTask.Parameters parameters = task.getParametersTyped();

        djfsAlbumsTaskDao.addSubtask(
                new DjfsAlbumsSubtask(DjfsUid.cons(parameters.getUid()), task.id().getId(), parameters)
        );

        bazingaTaskManager.schedule(new DjfsAlbumsQueueTask(parameters.getUid()));
    }

}
