package ru.yandex.chemodan.app.djfs.core.billing;

import com.mongodb.MongoClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

import ru.yandex.chemodan.app.djfs.core.db.DaoProxyFactory;
import ru.yandex.chemodan.app.djfs.core.db.DjfsDbContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.commune.dynproperties.DynamicProperty;

/**
 * @author eoshch
 */
@Configuration
@Import({
        DjfsDbContextConfiguration.class,
})
public class BillingContextConfiguration {
    private final DynamicProperty<Boolean> isBillingInPG =
            new DynamicProperty<>("djfs.common.is-billing-in-pg", false);

    @Bean
    public MongoBillingOrderDao mongoBillingOrderDao(@Qualifier("common") MongoClient mongoClient) {
        return new MongoBillingOrderDao(mongoClient);
    }

    @Bean
    public PgBillingOrderDao pgBillingOrderDao(PgShardedDaoContext dependencies) {
        return new PgBillingOrderDao(dependencies);
    }

    @Bean
    @Primary
    public BillingOrderDao billingOrderDaoProxy(DaoProxyFactory daoProxyFactory, MongoBillingOrderDao mongoDao,
            PgBillingOrderDao pgDao)
    {
        return daoProxyFactory.create(BillingOrderDao.class, pgDao, mongoDao, isBillingInPG::get);
    }

    @Bean
    public MongoBillingOrderHistoryDao mongoBillingOrderHistoryDao(@Qualifier("common") MongoClient mongoClient) {
        return new MongoBillingOrderHistoryDao(mongoClient);
    }

    @Bean
    public PgBillingOrderHistoryDao pgBillingOrderHistoryDao(PgShardedDaoContext dependencies) {
        return new PgBillingOrderHistoryDao(dependencies);
    }

    @Bean
    @Primary
    public BillingOrderHistoryDao billingOrderHistoryDaoProxy(DaoProxyFactory daoProxyFactory,
            MongoBillingOrderHistoryDao mongoDao,
            PgBillingOrderHistoryDao pgDao)
    {
        return daoProxyFactory.create(BillingOrderHistoryDao.class, pgDao, mongoDao, isBillingInPG::get);
    }

    @Bean
    public MongoBillingServiceDao mongoBillingServiceDao(@Qualifier("common") MongoClient mongoClient) {
        return new MongoBillingServiceDao(mongoClient);
    }

    @Bean
    public PgBillingServiceDao pgBillingServiceDao(PgShardedDaoContext dependencies) {
        return new PgBillingServiceDao(dependencies);
    }

    @Bean
    @Primary
    public BillingServiceDao billingServiceDaoProxy(DaoProxyFactory daoProxyFactory, MongoBillingServiceDao mongoDao,
            PgBillingServiceDao pgDao)
    {
        return daoProxyFactory.create(BillingServiceDao.class, pgDao, mongoDao, isBillingInPG::get);
    }

    @Bean
    public MongoBillingServiceHistoryDao mongoBillingServiceHistoryDao(@Qualifier("common") MongoClient mongoClient) {
        return new MongoBillingServiceHistoryDao(mongoClient);
    }

    @Bean
    public PgBillingServiceHistoryDao pgBillingServiceHistoryDao(PgShardedDaoContext dependencies) {
        return new PgBillingServiceHistoryDao(dependencies);
    }

    @Bean
    @Primary
    public BillingServiceHistoryDao billingServiceHistoryDaoProxy(DaoProxyFactory daoProxyFactory,
            MongoBillingServiceHistoryDao mongoDao,
            PgBillingServiceHistoryDao pgDao)
    {
        return daoProxyFactory.create(BillingServiceHistoryDao.class, pgDao, mongoDao, isBillingInPG::get);
    }

    @Bean
    public MongoBillingServiceAttributeDao mongoBillingServiceAttributeDao(
            @Qualifier("common") MongoClient mongoClient)
    {
        return new MongoBillingServiceAttributeDao(mongoClient);
    }

    @Bean
    public PgBillingServiceAttributeDao pgBillingServiceAttributeDao(PgShardedDaoContext dependencies) {
        return new PgBillingServiceAttributeDao(dependencies);
    }

    @Bean
    @Primary
    public BillingServiceAttributeDao billingServiceAttributeDaoProxy(DaoProxyFactory daoProxyFactory,
            MongoBillingServiceAttributeDao mongoDao,
            PgBillingServiceAttributeDao pgDao)
    {
        return daoProxyFactory.create(BillingServiceAttributeDao.class, pgDao, mongoDao, isBillingInPG::get);
    }

    @Bean
    public MongoBillingServiceAttributeHistoryDao mongoBillingServiceAttributeHistoryDao(
            @Qualifier("common") MongoClient mongoClient)
    {
        return new MongoBillingServiceAttributeHistoryDao(mongoClient);
    }

    @Bean
    public PgBillingServiceAttributeHistoryDao pgBillingServiceAttributeHistoryDao(PgShardedDaoContext dependencies) {
        return new PgBillingServiceAttributeHistoryDao(dependencies);
    }

    @Bean
    @Primary
    public BillingServiceAttributeHistoryDao billingServiceAttributeHistoryDaoProxy(DaoProxyFactory daoProxyFactory,
            MongoBillingServiceAttributeHistoryDao mongoDao,
            PgBillingServiceAttributeHistoryDao pgDao)
    {
        return daoProxyFactory.create(BillingServiceAttributeHistoryDao.class, pgDao, mongoDao, isBillingInPG::get);
    }

    @Bean
    public MongoBillingSubscriptionDao mongoBillingSubscriptionDao(@Qualifier("common") MongoClient mongoClient) {
        return new MongoBillingSubscriptionDao(mongoClient);
    }

    @Bean
    public PgBillingSubscriptionDao pgBillingSubscriptionDao(PgShardedDaoContext dependencies) {
        return new PgBillingSubscriptionDao(dependencies);
    }

    @Bean
    @Primary
    public BillingSubscriptionDao billingSubscriptionDaoProxy(DaoProxyFactory daoProxyFactory,
            MongoBillingSubscriptionDao mongoDao,
            PgBillingSubscriptionDao pgDao)
    {
        return daoProxyFactory.create(BillingSubscriptionDao.class, pgDao, mongoDao, isBillingInPG::get);
    }

    @Bean
    public BillingManager billingManager(BillingServiceDao billingServiceDao,
            BillingServiceAttributeDao billingServiceAttributeDao)
    {
        return new BillingManager(billingServiceDao, billingServiceAttributeDao);
    }
}
