package ru.yandex.chemodan.app.djfs.core.billing;

import com.mongodb.ReadPreference;
import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.core.util.InstantUtils;

/**
 * @author eoshch
 */
@RequiredArgsConstructor
public class BillingManager {
    public static final MapF<String, Long> SPACE = Cf.toMap(Tuple2List.fromPairs(
            "rostelecom_2014_100gb", 107374182400L,
            "rostelecom_2015_100gb_paid", 107374182400L,
            "search_app_promo_gift", 53687091200L,
            "yandex_plus_10gb", 10737418240L,
            "initial_3gb", 3221225472L,
            "initial_10gb", 10737418240L,
            "app_install", 3221225472L,
            "file_uploaded", 2147483648L,
            "promo_shared", 2147483648L,
            "invited", 1073741824L,
            "referral", 536870912L,
            "turkish", 1073741824L,
            "photostream_used", 34359738368L,
            "ny_2014", 2111832064L,
            "b2b_1tb", 1099511627776L,
            "b2b_250gb", 268435456000L,
            "b2b_10gb", 10737418240L,
            "b2b_fake_organization_free_space", 0L,
            "32_gb_autoupload", 34359738368L,
            "special_offer_1_tb_for_english_lessons", 1099511627776L,
            "back_to_school", 34359738368L,
            "test_1kb_eternal", 1024L,
            "test_1kb_for_one_second", 1024L,
            "test_1kb_for_two_seconds", 1024L,
            "test_1kb_for_five_seconds", 1024L,
            "test_1kb_for_five_seconds_with_attrs", 0L,
            "test_1kb_for_one_minute", 1024L,
            "test_1GB_for_five_minutes_for_1_rub", 1073741824L,
            "test_10GB_for_five_minutes", 10737418240L,
            "test_1kb_for_one_month", 1024L,
            "test_10GB_for_10_minutes_with_10m_charging_retry_every_1m", 1073741824L,
            "test_10GB_for_20_minutes_with_180m_charging_retry_every_10m", 1073741824L,
            "test_10GB_for_200_minutes_with_180m_charging_retry_every_10m", 1073741824L,
            "samsung_ultrabook", 268435456000L,
            "yandex_mobile_services", 53687091200L,
            "media_markt_tablets", 53687091200L,
            "sony_tablet", 42949672960L,
            "samsung_notebook", 32212254720L,
            "samsung_201309", 53687091200L,
            "sony_notebook", 32212254720L,
            "intel_device", 32212254720L,
            "kingston_flash", 0L,
            "10gb_1m", 10737418240L,
            "10gb_1y", 10737418240L,
            "100gb_1m", 107374182400L,
            "100gb_1y", 107374182400L,
            "1tb_1m", 1099511627776L,
            "1tb_1y", 1099511627776L,
            "10gb_1m_2014", 10737418240L,
            "10gb_1y_2014", 10737418240L,
            "100gb_1m_2014", 107374182400L,
            "100gb_1y_2014", 107374182400L,
            "1tb_1m_2014", 1099511627776L,
            "1tb_1y_2014", 1099511627776L,
            "10gb_1m_2015", 10737418240L,
            "10gb_1y_2015", 10737418240L,
            "10gb_1y_sale_20_2015", 10737418240L,
            "100gb_1m_2015", 107374182400L,
            "100gb_1y_2015", 107374182400L,
            "100gb_1y_sale_20_2015", 107374182400L,
            "1tb_1m_2015", 1099511627776L,
            "1tb_1y_2015", 1099511627776L,
            "1tb_1y_sale_20_2015", 1099511627776L,
            "100gb_1m_2018", 107374182400L,
            "100gb_1y_2018", 107374182400L,
            "1tb_1m_2018", 1099511627776L,
            "1tb_1y_2018", 1099511627776L,
            "100gb_1m_2018_discount_10", 107374182400L,
            "100gb_1y_2018_discount_10", 107374182400L,
            "1tb_1m_2018_discount_10", 1099511627776L,
            "1tb_1y_2018_discount_10", 1099511627776L,
            "100gb_1m_2018_discount_20", 107374182400L,
            "100gb_1y_2018_discount_20", 107374182400L,
            "1tb_1m_2018_discount_20", 1099511627776L,
            "1tb_1y_2018_discount_20", 1099511627776L,
            "100gb_1m_2018_discount_30", 107374182400L,
            "100gb_1y_2018_discount_30", 107374182400L,
            "1tb_1m_2018_discount_30", 1099511627776L,
            "1tb_1y_2018_discount_30", 1099511627776L,
            "yandex_staff", 268435456000L,
            "yandex_mail_birthday", 0L,
            "yandex_mail_mobile_app_installation", 17179869184L,
            "blat", 10737418240L,
            "blat_100", 107374182400L,
            "blat_250", 268435456000L,
            "passport_split", 5368709120L,
            "music_dec_2012", 10737418240L,
            "turkey_proje_y", 10737418240L,
            "turkey_panorama", 10737418240L,
            "acmicpc", 268435456000L,
            "yandex_shad", 268435456000L,
            "yandex_browser", 5368709120L,
            "yandex_ege", 2147483648L,
            "20131201_install_fail", 214748364800L,
            "yandex_video", 0L,
            "yandex_webchat", 10737418240L,
            "common_fuckup", 0L,
            "fotki_closing_compensation", 0L,
            "yandex_mail_ranktable", 10737418240L,
            "10gb_1m_2016_group", 10737418240L,
            "10gb_1y_2016_group", 10737418240L,
            "100gb_1m_2016_group", 107374182400L,
            "100gb_1y_2016_group", 107374182400L,
            "1tb_1m_2016_group", 1099511627776L,
            "1tb_1y_2016_group", 1099511627776L,
            "250gb_forever_2016_group", 268435456000L,
            "test_group_1kb_eternal", 1024L,
            "test_group_1kb_for_one_second", 1024L,
            "test_group_1kb_for_two_seconds", 1024L,
            "test_group_1kb_for_five_seconds", 1024L,
            "test_group_1kb_for_one_minute", 1024L,
            "test_group_10GB_for_five_minutes", 10737418240L,
            "test_group_1kb_for_one_month", 1024L,
            "test_group_1kb_forever", 1024L,
            "euroset_1tb_1_year", 1099511627776L,
            "wikium_100_gb_1_year", 107374182400L,
            "promo_code_blat_100", 107374182400L,
            "promo_code_blat_100gb_1m", 107374182400L,
            "promo_code_blat_1tb_1m", 1099511627776L,
            "beeline_armenia_20gb", 21474836480L,
            "beeline_armenia_30gb", 32212254720L,
            "beeline_armenia_40gb", 42949672960L,
            "beeline_armenia_50gb", 53687091200L,
            "webmaster_competition_joke_30gb", 32212254720L,
            "webmaster_blat_50gb", 53687091200L,
            "webmaster_blat_100gb", 107374182400L,
            "spring_gigabytes_10gb_2018", 10737418240L,
            "telegram_10gb_2018", 10737418240L,
            "samsung_kazakhstan_2018", 10737418240L,
            "yac_2018_participant_100gb_eternal", 107374182400L,
            "yac_2018_participant_100gb_1y", 107374182400L,
            "megafon_100gb_1m_2018", 107374182400L,
            "megafon_1tb_1m_2018", 1099511627776L,
            "test_megafon_100gb_1m", 107374182400L,
            "test_megafon_1tb_1m", 1099511627776L,
            "test_promo_code_1kb_2min", 1024L,
            "test_promo_code_1kb_1m", 1024L,
            "test_promo_code_1kb_1y", 1024L,
            "test_promo_code_1kb_eternal", 1024L,
            "test_promo_code_1kb", 1024L,
            "test_promo_code_1kb_5sec", 1024L,
            "rostelecom_unlim_1", 1099511627776L,
            "rostelecom_unlim_2", 2199023255552L,
            "rostelecom_unlim_3", 3298534883328L,
            "rostelecom_vas_5gb", 5368709120L,
            "rostelecom_vas_100gb", 107374182400L,
            "rostelecom_vas_1tb", 1099511627776L,
            "rostelecom_unlim_1_test", 1099511627776L,
            "rostelecom_unlim_2_test", 2199023255552L,
            "rostelecom_unlim_3_test", 3298534883328L,
            "rostelecom_vas_5gb_test", 5368709120L,
            "rostelecom_vas_100gb_test", 107374182400L,
            "rostelecom_vas_1tb_test", 1099511627776L,
            "100gb_1m_2019", 107374182400L,
            "100gb_1m_2019_discount_10", 107374182400L,
            "100gb_1m_2019_discount_20", 107374182400L,
            "100gb_1m_2019_discount_30", 107374182400L,
            "100gb_1m_2019_v2", 107374182400L,
            "100gb_1m_2019_v2_discount_10", 107374182400L,
            "100gb_1m_2019_v2_discount_20", 107374182400L,
            "100gb_1m_2019_v2_discount_30", 107374182400L,
            "100gb_1m_2019_v3", 107374182400L,
            "100gb_1m_2019_v3_discount_10", 107374182400L,
            "100gb_1m_2019_v3_discount_20", 107374182400L,
            "100gb_1m_2019_v3_discount_30", 107374182400L,
            "100gb_1m_2019_v4", 107374182400L,
            "100gb_1m_2019_v4_discount_10", 107374182400L,
            "100gb_1m_2019_v4_discount_20", 107374182400L,
            "100gb_1m_2019_v4_discount_30", 107374182400L,
            "100gb_1y_2019", 107374182400L,
            "100gb_1y_2019_discount_10", 107374182400L,
            "100gb_1y_2019_discount_20", 107374182400L,
            "100gb_1y_2019_discount_30", 107374182400L,
            "100gb_1y_2019_v2", 107374182400L,
            "100gb_1y_2019_v2_discount_10", 107374182400L,
            "100gb_1y_2019_v2_discount_20", 107374182400L,
            "100gb_1y_2019_v2_discount_30", 107374182400L,
            "100gb_1y_2019_v3", 107374182400L,
            "100gb_1y_2019_v3_discount_10", 107374182400L,
            "100gb_1y_2019_v3_discount_20", 107374182400L,
            "100gb_1y_2019_v3_discount_30", 107374182400L,
            "100gb_1y_2019_v4", 107374182400L,
            "100gb_1y_2019_v4_discount_10", 107374182400L,
            "100gb_1y_2019_v4_discount_20", 107374182400L,
            "100gb_1y_2019_v4_discount_30", 107374182400L,
            "1tb_1m_2019", 1099511627776L,
            "1tb_1m_2019_discount_10", 1099511627776L,
            "1tb_1m_2019_discount_20", 1099511627776L,
            "1tb_1m_2019_discount_30", 1099511627776L,
            "1tb_1m_2019_v2", 1099511627776L,
            "1tb_1m_2019_v2_discount_10", 1099511627776L,
            "1tb_1m_2019_v2_discount_20", 1099511627776L,
            "1tb_1m_2019_v2_discount_30", 1099511627776L,
            "1tb_1m_2019_v3", 1099511627776L,
            "1tb_1m_2019_v3_discount_10", 1099511627776L,
            "1tb_1m_2019_v3_discount_20", 1099511627776L,
            "1tb_1m_2019_v3_discount_30", 1099511627776L,
            "1tb_1m_2019_v4", 1099511627776L,
            "1tb_1m_2019_v4_discount_10", 1099511627776L,
            "1tb_1m_2019_v4_discount_20", 1099511627776L,
            "1tb_1m_2019_v4_discount_30", 1099511627776L,
            "1tb_1y_2019", 1099511627776L,
            "1tb_1y_2019_discount_10", 1099511627776L,
            "1tb_1y_2019_discount_20", 1099511627776L,
            "1tb_1y_2019_discount_30", 1099511627776L,
            "1tb_1y_2019_v2", 1099511627776L,
            "1tb_1y_2019_v2_discount_10", 1099511627776L,
            "1tb_1y_2019_v2_discount_20", 1099511627776L,
            "1tb_1y_2019_v2_discount_30", 1099511627776L,
            "1tb_1y_2019_v3", 1099511627776L,
            "1tb_1y_2019_v3_discount_10", 1099511627776L,
            "1tb_1y_2019_v3_discount_20", 1099511627776L,
            "1tb_1y_2019_v3_discount_30", 1099511627776L,
            "1tb_1y_2019_v4", 1099511627776L,
            "1tb_1y_2019_v4_discount_10", 1099511627776L,
            "1tb_1y_2019_v4_discount_20", 1099511627776L,
            "1tb_1y_2019_v4_discount_30", 1099511627776L,
            "5tb_1y_blogger", 5497558138880L,
            "disk_ny_2019_10gb_1m", 10737418240L,
            "megafon_100gb_6m_2018", 107374182400L,
            "megafon_1tb_6m_2018", 1099511627776L,
            "yandex_directory_1tb", 1099511627776L,
            "test_assessor_promo_code_service", -1L,
            "100gb_1m_apple_appstore_2019", 107374182400L,
            "100gb_1m_google_play_2019", 107374182400L,
            "100gb_1y_apple_appstore_2019", 107374182400L,
            "100gb_1y_google_play_2019", 107374182400L,
            "1tb_1m_apple_appstore_2019", 1099511627776L,
            "1tb_1m_google_play_2019", 1099511627776L,
            "1tb_1y_apple_appstore_2019", 1099511627776L,
            "1tb_1y_google_play_2019", 1099511627776L,
            "3tb_1m_2019", 3298534883328L,
            "3tb_1m_2019_discount_10", 3298534883328L,
            "3tb_1m_2019_discount_20", 3298534883328L,
            "3tb_1m_2019_discount_30", 3298534883328L,
            "3tb_1m_apple_appstore_2019", 3298534883328L,
            "3tb_1m_google_play_2019", 3298534883328L,
            "3tb_1y_2019", 3298534883328L,
            "3tb_1y_2019_discount_10", 3298534883328L,
            "3tb_1y_2019_discount_20", 3298534883328L,
            "3tb_1y_2019_discount_30", 3298534883328L,
            "3tb_1y_apple_appstore_2019", 3298534883328L,
            "3tb_1y_google_play_2019", 3298534883328L,
            "ru.yandex.web.disk.native.1month.autorenewable.notrial.disk_basic.750", 3298534883328L,
            "ru.yandex.web.disk.native.1year.autorenewable.notrial.disk_basic.6500", 3298534883328L,
            "ru.yandex.web.disk.native.20min.autorenewable.notrial.disk_basic.10.debug", 3298534883328L,
            "100gb_eternal_friends", 107374182400L,
            "1tb_eternal", 1099511627776L,
            "1tb_eternal_friends", 1099511627776L,
            "yandex_disk_for_business", 0L,
            "yandex_mail_pro", 0L,
            "yandex_b2c_mail_pro", 0L,
            "yandex_b2c_mail_pro_promo", 0L,
            "yandex_b2b_mail_pro", 0L,
            "mail_pro_promo_20gb", 21474836480L
    ));

    private static final SetF<String> PAID_PRODUCTS = Cf.set(
            "100gb_1m_2019_v3", "100gb_1y_2019_discount_10", "100gb_1m_2014", "100gb_1m_2019_v2", "3tb_1y_2019",
            "100gb_1y_2019_v3_discount_20", "100gb_1m_2019_discount_10", "3tb_1m_2019", "10gb_1y_2015", "10gb_1y_2014",
            "100gb_1m_2019_discount_30", "1tb_1m_2019_v4_discount_10", "3tb_1m_2019_discount_30",
            "1tb_1y_2019_discount_20", "3tb_1m_yandex_plus_upsale_2019", "100gb_1m_2019_v3_discount_10",
            "1tb_1m_2019_v3_discount_10", "rostelecom_vas_100gb", "rostelecom_vas_1tb", "100gb_1m_2019_v4",
            "3tb_1y_2019_discount_10", "100gb_1m_2019_v2_discount_20", "1tb_1m_2019", "1tb_1m_2018",
            "1tb_1m_2019_discount_10", "rostelecom_vas_5gb", "rostelecom_unlim_2_test", "100gb_1m_2018_discount_20",
            "1tb_1m_2015", "1tb_1m_2014", "100gb_1m_2019_v4_discount_30", "100gb_1y_sale_20_2015",
            "1tb_1y_2018_discount_30", "10gb_1m", "1tb_1m_2018_discount_10", "1tb_1m_2019_v2", "1tb_1m_2019_v3",
            "100gb_1m_2019_v2_discount_30", "1tb_1m_2019_v4", "100gb_1y_2019_v4_discount_10", "10gb_1y", "100gb_1y",
            "100gb_1y_2018_discount_10", "1tb_1m_2018_discount_20", "1tb_1m", "100gb_1m_2015", "100gb_1m_2018",
            "100gb_1m_2019", "1tb_1y_2019_v4_discount_30", "rostelecom_vas_5gb_test", "100gb_1y_2019_v4",
            "100gb_1y_2019_v3", "100gb_1y_2019_v2", "1tb_1y_2019_v3_discount_10", "3tb_1y_2019_discount_20",
            "1tb_1m_2019_v3_discount_20", "1tb_1y_2019_v2_discount_20", "1tb_1m_2019_v2_discount_30", "100gb_1y_2014",
            "3tb_1y_yandex_plus_upsale_2019", "1tb_1m_apple_appstore_2019", "1tb_1y_2019_discount_10",
            "10gb_1y_sale_20_2015", "1tb_1y_apple_appstore_2019", "100gb_1m_2018_discount_30", "100gb_1y_2018",
            "100gb_1y_2019", "1tb_1y_2018_discount_20", "1tb_1m_2019_discount_20", "100gb_1y_2019_discount_30",
            "100gb_1y_2019_v2_discount_10", "1tb_1y", "3tb_1m_2019_discount_10", "1tb_1m_2019_v4_discount_30",
            "100gb_1y_2019_v4_discount_20", "10gb_1m_2015", "10gb_1m_2014", "100gb_1m_2019_v3_discount_30",
            "100gb_1y_2019_v3_discount_10", "rostelecom_unlim_1", "1tb_1m_2019_discount_30",
            "1tb_1m_2019_v3_discount_30", "100gb_1m", "1tb_1y_2019_v3_discount_20", "100gb_1y_2018_discount_20",
            "1tb_1y_2019_v2_discount_10", "100gb_1y_2015", "100gb_1m_2019_v4_discount_10", "3tb_1y_2019_discount_30",
            "1tb_1m_2019_v2_discount_20", "100gb_1y_2019_v2_discount_30", "1tb_1y_2019_v4_discount_20",
            "1tb_1m_2018_discount_30", "100gb_1m_2019_discount_20", "100gb_1y_2019_v2_discount_20",
            "100gb_1y_2019_v3_discount_30", "1tb_1y_2019_v4", "rostelecom_unlim_3_test", "1tb_1y_2019_v2",
            "1tb_1y_2019_v3", "rostelecom_vas_100gb_test", "1tb_1y_2019_v4_discount_10", "1tb_1m_2019_v4_discount_20",
            "1tb_1y_2019_v2_discount_30", "1tb_1y_2014", "100gb_1y_2019_discount_20", "100gb_1y_2019_v4_discount_30",
            "3tb_1m_2019_discount_20", "100gb_1y_2018_discount_30", "100gb_1m_2019_v3_discount_20",
            "rostelecom_vas_1tb_test", "1tb_1y_2019_discount_30", "1tb_1y_2019_v3_discount_30",
            "100gb_1m_2018_discount_10", "rostelecom_unlim_1_test", "rostelecom_unlim_2", "rostelecom_unlim_3",
            "1tb_1y_2019", "1tb_1y_2018", "100gb_1m_2019_v2_discount_10", "1tb_1y_2015", "1tb_1y_sale_20_2015",
            "1tb_1y_2018_discount_10", "100gb_1m_2019_v4_discount_20", "1tb_1m_2019_v2_discount_10",
            "yandex_directory_1tb", "100gb_1m_apple_appstore_2019", "100gb_1m_google_play_2019",
            "100gb_1y_apple_appstore_2019", "100gb_1y_google_play_2019", "1tb_1m_apple_appstore_2019",
            "1tb_1m_google_play_2019", "1tb_1y_apple_appstore_2019", "1tb_1y_google_play_2019", "3tb_1m_2019",
            "3tb_1m_2019_discount_10", "3tb_1m_2019_discount_20", "3tb_1m_2019_discount_30",
            "3tb_1m_apple_appstore_2019", "3tb_1m_google_play_2019", "3tb_1y_2019", "3tb_1y_2019_discount_10",
            "3tb_1y_2019_discount_20", "3tb_1y_2019_discount_30", "3tb_1y_apple_appstore_2019",
            "3tb_1y_google_play_2019", "ru.yandex.web.disk.native.1month.autorenewable.notrial.disk_basic.750",
            "ru.yandex.web.disk.native.1year.autorenewable.notrial.disk_basic.6500",
            "ru.yandex.web.disk.native.20min.autorenewable.notrial.disk_basic.10.debug",
            "yandex_mail_pro", "yandex_disk_for_business", "yandex_b2c_mail_pro", "yandex_b2b_mail_pro"
    );

    private final BillingServiceDao billingServiceDaoProxy;
    private final BillingServiceAttributeDao billingServiceAttributeDaoProxy;

    public ListF<BillingProduct> findProducts(DjfsUid uid, Option<ReadPreference> readPreference) {
        ListF<BillingService> services = billingServiceDaoProxy.findAll(uid, readPreference);
        MapF<String, BillingServiceAttribute> attributes = billingServiceAttributeDaoProxy.findAll(uid, readPreference)
                .toMapMappingToKey(BillingServiceAttribute::getId);

        return services.map(x -> BillingProduct.builder()
                .id(x.getId())
                .productId(x.getPid())
                .uid(uid)
                .spaceAmount(attributes.getO(x.getId()).filterMap(BillingServiceAttribute::getAmount).orElse(SPACE.getO(x.getPid()))
                        .getOrThrow("no attributes or pid for " + x.getId() + " " + x.getPid()))
                .build());
    }

    // TODO: not ready for production
    public void addProduct(DjfsUid uid, BillingProduct billingProduct) {
        long version = InstantUtils.currentVersion();

        Option<Long> defaultSpace = SPACE.getO(billingProduct.getProductId());
        BillingService billingService = BillingService.builder()
                .id(billingProduct.getId())
                .pid(billingProduct.getProductId())
                .uid(uid)
                .v(Option.of(version))
                .build();
        billingServiceDaoProxy.insert(billingService);

        if (!defaultSpace.isPresent() || defaultSpace.get() <= 0) {
            BillingServiceAttribute billingServiceAttribute = BillingServiceAttribute.builder()
                    .id(billingProduct.getId())
                    .uid(uid)
                    .amount(Option.of(billingProduct.getSpaceAmount()))
                    .v(Option.of(version))
                    .build();
            billingServiceAttributeDaoProxy.insert(billingServiceAttribute);
        }
    }
}
