package ru.yandex.chemodan.app.djfs.core.billing;

import com.mongodb.ReadPreference;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.Sharded;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author m-messiah
 */
public interface BillingServiceAttributeDao {
    @Sharded
    void insert(BillingServiceAttribute billingServiceAttribute);

    @Sharded
    void insert(ListF<BillingServiceAttribute> billingServiceAttribute);

    /**
     * Use in tests only!
     * Not ready for production!
     */
    @Sharded
    ListF<BillingServiceAttribute> findAll(DjfsUid uid, Option<ReadPreference> readPreference);

    /**
     * Use in tests only!
     * Not ready for production!
     */
    @Sharded
    void deleteAll(DjfsUid uid);
}
