package ru.yandex.chemodan.app.djfs.core.billing;

import com.mongodb.ReadPreference;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.Sharded;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author m-messiah
 */
public interface BillingServiceDao {
    @Sharded
    void insert(BillingService billingService);

    @Sharded
    void insert(ListF<BillingService> billingService);

    /**
     * Use in tests only!
     * Not ready for production!
     */
    @Sharded
    ListF<BillingService> findAll(DjfsUid uid, Option<ReadPreference> readPreference);

    /**
     * Use in tests only!
     * Not ready for production!
     */
    @Sharded
    void deleteAll(DjfsUid uid);
}
