package ru.yandex.chemodan.app.djfs.core.billing;

import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author eoshch
 */
@BenderBindAllFields
public class MongoBillingOrder extends DefaultObject {
    public static final MongoBenderParserSerializer<String, MongoBillingOrder> B =
            DjfsBenderFactory.createForMongo(MongoBillingOrder.class);

    @MongoId
    public String id;
    public String uid;

    public BillingOrder to() {
        return BillingOrder.builder()
                .id(id)
                .uid(DjfsUid.cons(uid))
                .build();
    }
    public static MongoBillingOrder cons(BillingOrder billingOrder) {
        MongoBillingOrder result = new MongoBillingOrder();
        result.id = billingOrder.getId();
        result.uid = billingOrder.getUid().asString();
        return result;
    }
}
