package ru.yandex.chemodan.app.djfs.core.billing;

import com.mongodb.MongoClient;
import com.mongodb.client.model.Filters;
import org.bson.BsonDocument;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoCollectionX;

/**
 * @author eoshch
 */

public class MongoBillingOrderDao implements BillingOrderDao {
    private final MongoCollectionX<String, MongoBillingOrder> collection;

    public MongoBillingOrderDao(MongoClient mongoClient) {
        this.collection = new MongoCollectionX<>(
                mongoClient.getDatabase("billing_orders").getCollection("billing_orders", BsonDocument.class),
                MongoBillingOrder.B);
    }

    @Override
    public void insert(BillingOrder billingOrder) {
        throw new NotImplementedException();
    }

    @Override
    public void insert(ListF<BillingOrder> billingOrders) {
        throw new NotImplementedException();
    }

    @Override
    public ListF<BillingOrder> findAll(DjfsUid uid) {
        return collection.find(Filters.eq("uid", uid.asString())).map(MongoBillingOrder::to);
    }

    public void deleteAll(DjfsUid uid) {
        collection.deleteMany(Filters.eq("uid", uid.asString()));
    }
}
