package ru.yandex.chemodan.app.djfs.core.billing;

import org.bson.types.ObjectId;

import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author eoshch
 */
@BenderBindAllFields
public class MongoBillingOrderHistory extends DefaultObject {
    public static final MongoBenderParserSerializer<String, MongoBillingOrderHistory> B =
            DjfsBenderFactory.createForMongo(MongoBillingOrderHistory.class);

    @MongoId
    public ObjectId id;
    public String uid;

    public BillingOrderHistory to() {
        return BillingOrderHistory.builder()
                .id(id)
                .uid(DjfsUid.cons(uid))
                .build();
    }
    public static MongoBillingOrderHistory cons(BillingOrderHistory billingOrderHistory) {
        MongoBillingOrderHistory result = new MongoBillingOrderHistory();
        result.id = billingOrderHistory.getId();
        result.uid = billingOrderHistory.getUid().asString();
        return result;
    }
}
