package ru.yandex.chemodan.app.djfs.core.billing;

import com.mongodb.MongoClient;
import com.mongodb.client.model.Filters;
import org.bson.BsonDocument;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoCollectionX;

/**
 * @author eoshch
 */
public class MongoBillingOrderHistoryDao implements BillingOrderHistoryDao{
    private final MongoCollectionX<String, MongoBillingOrderHistory> collection;

    public MongoBillingOrderHistoryDao(MongoClient mongoClient) {
        this.collection = new MongoCollectionX<>(
                mongoClient.getDatabase("billing_orders_history")
                        .getCollection("billing_orders_history", BsonDocument.class),
                MongoBillingOrderHistory.B);
    }

    @Override
    public void insert(BillingOrderHistory billingOrderHistory) {
        throw new NotImplementedException();
    }

    @Override
    public void insert(ListF<BillingOrderHistory> billingOrdersHistory) {
        throw new NotImplementedException();
    }

    @Override
    public ListF<BillingOrderHistory> findAll(DjfsUid uid) {
        return collection.find(Filters.eq("uid", uid.asString())).map(MongoBillingOrderHistory::to);
    }

    public void deleteAll(DjfsUid uid) {
        collection.deleteMany(Filters.eq("uid", uid.asString()));
    }
}
