package ru.yandex.chemodan.app.djfs.core.billing;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author eoshch
 */
@BenderBindAllFields
public class MongoBillingService extends DefaultObject {
    public static final MongoBenderParserSerializer<String, MongoBillingService> B =
            DjfsBenderFactory.createForMongo(MongoBillingService.class);

    @MongoId
    public String id;
    public String uid;
    public String pid;
    public Option<Long> v;

    public BillingService to() {
        return BillingService.builder()
                .id(id)
                .uid(DjfsUid.cons(uid))
                .pid(pid)
                .v(v)
                .build();
    }
    public static MongoBillingService cons(BillingService billingService) {
        MongoBillingService result = new MongoBillingService();
        result.id = billingService.getId();
        result.uid = billingService.getUid().asString();
        result.pid = billingService.getPid();
        result.v = billingService.getV();
        return result;
    }
}
