package ru.yandex.chemodan.app.djfs.core.billing;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author eoshch
 */
@BenderBindAllFields
public class MongoBillingServiceAttribute extends DefaultObject {
    public static final MongoBenderParserSerializer<String, MongoBillingServiceAttribute> B =
            DjfsBenderFactory.createForMongo(MongoBillingServiceAttribute.class);

    @MongoId
    public String id;
    public String uid;
    public Option<Long> amount;
    public Option<Long> v;

    public BillingServiceAttribute to() {
        return BillingServiceAttribute.builder()
                .id(id)
                .uid(DjfsUid.cons(uid))
                .amount(amount)
                .v(v)
                .build();
    }
    public static MongoBillingServiceAttribute cons(BillingServiceAttribute billingServiceAttribute) {
        MongoBillingServiceAttribute result = new MongoBillingServiceAttribute();
        result.id = billingServiceAttribute.getId();
        result.uid = billingServiceAttribute.getUid().asString();
        result.amount = billingServiceAttribute.getAmount();
        result.v = billingServiceAttribute.getV();
        return result;
    }
}
