package ru.yandex.chemodan.app.djfs.core.billing;

import com.mongodb.MongoClient;
import com.mongodb.ReadPreference;
import com.mongodb.client.model.Filters;
import org.bson.BsonDocument;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoCollectionX;

/**
 * @author m-messiah
 */
public class MongoBillingServiceAttributeDao implements BillingServiceAttributeDao {
    private final MongoCollectionX<String, MongoBillingServiceAttribute> collection;

    public MongoBillingServiceAttributeDao(MongoClient mongoClient) {
        this.collection = new MongoCollectionX<>(
                mongoClient.getDatabase("billing_service_attributes")
                        .getCollection("billing_service_attributes", BsonDocument.class),
                MongoBillingServiceAttribute.B);
    }

    @Override
    public void insert(BillingServiceAttribute billingServiceAttribute) {
        collection.insertOne(MongoBillingServiceAttribute.cons(billingServiceAttribute));
    }

    @Override
    public void insert(ListF<BillingServiceAttribute> billingServiceAttribute) {
        collection.insertMany(billingServiceAttribute.map(MongoBillingServiceAttribute::cons));
    }

    @Override
    public ListF<BillingServiceAttribute> findAll(DjfsUid uid, Option<ReadPreference> readPreference) {
        return readPreference.map(rp -> collection.find(Filters.eq("uid", uid.asString()), rp))
                .getOrElse(() -> collection.find(Filters.eq("uid", uid.asString()))).map(MongoBillingServiceAttribute::to);
    }

    public void deleteAll(DjfsUid uid) {
        collection.deleteMany(Filters.eq("uid", uid.asString()));
    }
}
