package ru.yandex.chemodan.app.djfs.core.billing;

import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author eoshch
 */
@BenderBindAllFields
public class MongoBillingServiceAttributeHistory extends DefaultObject {
    public static final MongoBenderParserSerializer<String, MongoBillingServiceAttributeHistory> B =
            DjfsBenderFactory.createForMongo(MongoBillingServiceAttributeHistory.class);

    @MongoId
    public String id;
    public String uid;

    public BillingServiceAttributeHistory to() {
        return BillingServiceAttributeHistory.builder()
                .id(id)
                .uid(DjfsUid.cons(uid))
                .build();
    }
    public static MongoBillingServiceAttributeHistory cons(BillingServiceAttributeHistory billingServiceAttributeHistory) {
        MongoBillingServiceAttributeHistory result = new MongoBillingServiceAttributeHistory();
        result.id = billingServiceAttributeHistory.getId();
        result.uid = billingServiceAttributeHistory.getUid().asString();
        return result;
    }
}
