package ru.yandex.chemodan.app.djfs.core.billing;

import com.mongodb.MongoClient;
import com.mongodb.client.model.Filters;
import org.bson.BsonDocument;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoCollectionX;

/**
 * @author eoshch
 */
public class MongoBillingServiceAttributeHistoryDao implements BillingServiceAttributeHistoryDao {
    private final MongoCollectionX<String, MongoBillingServiceAttributeHistory> collection;

    public MongoBillingServiceAttributeHistoryDao(MongoClient mongoClient) {
        this.collection = new MongoCollectionX<>(
                mongoClient.getDatabase("billing_service_attributes_history")
                        .getCollection("billing_service_attributes_history", BsonDocument.class),
                MongoBillingServiceAttributeHistory.B);
    }

    @Override
    public void insert(BillingServiceAttributeHistory billingServiceAttributeHistory) {
        throw new NotImplementedException();
    }

    @Override
    public void insert(ListF<BillingServiceAttributeHistory> billingServiceAttributeHistory) {
        throw new NotImplementedException();
    }

    @Override
    public ListF<BillingServiceAttributeHistory> findAll(DjfsUid uid) {
        return collection.find(Filters.eq("uid", uid.asString())).map(MongoBillingServiceAttributeHistory::to);
    }

    public void deleteAll(DjfsUid uid) {
        collection.deleteMany(Filters.eq("uid", uid.asString()));
    }
}
