package ru.yandex.chemodan.app.djfs.core.billing;

import com.mongodb.MongoClient;
import com.mongodb.ReadPreference;
import com.mongodb.client.model.Filters;
import org.bson.BsonDocument;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoCollectionX;

/**
 * @author eoshch
 */
public class MongoBillingServiceDao implements BillingServiceDao  {
    private final MongoCollectionX<String, MongoBillingService> collection;

    public MongoBillingServiceDao(MongoClient mongoClient) {
        this.collection = new MongoCollectionX<>(
                mongoClient.getDatabase("billing_services")
                        .getCollection("billing_services", BsonDocument.class),
                MongoBillingService.B);
    }

    @Override
    public void insert(BillingService billingService) {
        collection.insertOne(MongoBillingService.cons(billingService));
    }

    @Override
    public void insert(ListF<BillingService> billingService) {
        collection.insertMany(billingService.map(MongoBillingService::cons));
    }

    @Override
    public ListF<BillingService> findAll(DjfsUid uid, Option<ReadPreference> readPreference) {
        return readPreference.map(rp -> collection.find(Filters.eq("uid", uid.asString()), rp))
                    .getOrElse(() -> collection.find(Filters.eq("uid", uid.asString()))).map(MongoBillingService::to);
    }

    public void deleteAll(DjfsUid uid) {
        collection.deleteMany(Filters.eq("uid", uid.asString()));
    }
}
