package ru.yandex.chemodan.app.djfs.core.billing;

import org.bson.types.ObjectId;

import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author eoshch
 */
@BenderBindAllFields
public class MongoBillingServiceHistory extends DefaultObject {
    public static final MongoBenderParserSerializer<ObjectId, MongoBillingServiceHistory> B =
            DjfsBenderFactory.createForMongo(MongoBillingServiceHistory.class);

    @MongoId
    public ObjectId id;
    public String uid;

    public BillingServiceHistory to() {
        return BillingServiceHistory.builder()
                .id(id)
                .uid(DjfsUid.cons(uid))
                .build();
    }
    public static MongoBillingServiceHistory cons(BillingServiceHistory billingServiceHistory) {
        MongoBillingServiceHistory result = new MongoBillingServiceHistory();
        result.id = billingServiceHistory.getId();
        result.uid = billingServiceHistory.getUid().asString();
        return result;
    }
}
