package ru.yandex.chemodan.app.djfs.core.billing;

import com.mongodb.MongoClient;
import com.mongodb.client.model.Filters;
import org.bson.BsonDocument;
import org.bson.types.ObjectId;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoCollectionX;

/**
 * @author eoshch
 */
public class MongoBillingServiceHistoryDao implements BillingServiceHistoryDao {
    private final MongoCollectionX<ObjectId, MongoBillingServiceHistory> collection;

    public MongoBillingServiceHistoryDao(MongoClient mongoClient) {
        this.collection = new MongoCollectionX<>(
                mongoClient.getDatabase("billing_services_history")
                        .getCollection("billing_services_history", BsonDocument.class),
                MongoBillingServiceHistory.B);
    }

    @Override
    public void insert(BillingServiceHistory billingServiceHistory) {
        throw new NotImplementedException();
    }

    @Override
    public void insert(ListF<BillingServiceHistory> billingServiceHistory) {
        throw new NotImplementedException();
    }

    @Override
    public ListF<BillingServiceHistory> findAll(DjfsUid uid) {
        return collection.find(Filters.eq("uid", uid.asString())).map(MongoBillingServiceHistory::to);
    }

    public void deleteAll(DjfsUid uid) {
        collection.deleteMany(Filters.eq("uid", uid.asString()));
    }
}
