package ru.yandex.chemodan.app.djfs.core.billing;

import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author eoshch
 */
@BenderBindAllFields
public class MongoBillingSubscription extends DefaultObject {
    public static final MongoBenderParserSerializer<String, MongoBillingSubscription> B =
            DjfsBenderFactory.createForMongo(MongoBillingSubscription.class);

    @MongoId
    public String id;
    public String uid;

    public BillingSubscription to() {
        return BillingSubscription.builder()
                .id(id)
                .uid(DjfsUid.cons(uid))
                .build();
    }
    public static MongoBillingSubscription cons(BillingSubscription billingSubscription) {
        MongoBillingSubscription result = new MongoBillingSubscription();
        result.id = billingSubscription.getId();
        result.uid = billingSubscription.getUid().asString();
        return result;
    }
}
