package ru.yandex.chemodan.app.djfs.core.billing;

import com.mongodb.MongoClient;
import com.mongodb.client.model.Filters;
import org.bson.BsonDocument;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.mongo3.MongoCollectionX;

/**
 * @author eoshch
 */
public class MongoBillingSubscriptionDao implements BillingSubscriptionDao {
    private final MongoCollectionX<String, MongoBillingSubscription> collection;

    public MongoBillingSubscriptionDao(MongoClient mongoClient) {
        this.collection = new MongoCollectionX<>(
                mongoClient.getDatabase("billing_subscriptions")
                        .getCollection("billing_subscriptions", BsonDocument.class),
                MongoBillingSubscription.B);
    }

    @Override
    public void insert(BillingSubscription billingSubscription) {
        throw new NotImplementedException();
    }

    @Override
    public void insert(ListF<BillingSubscription> billingSubscription) {
        throw new NotImplementedException();
    }

    @Override
    public ListF<BillingSubscription> findAll(DjfsUid uid) {
        return collection.find(Filters.eq("uid", uid.asString())).map(MongoBillingSubscription::to);
    }

    public void deleteAll(DjfsUid uid) {
        collection.deleteMany(Filters.eq("uid", uid.asString()));
    }
}
