package ru.yandex.chemodan.app.djfs.core.billing;

import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDao;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author m-messiah
 */
public class PgBillingOrderDao extends PgShardedDao implements BillingOrderDao {
    private final static RowMapper<BillingOrder> M = (rs, rowNum) -> {
        return BillingOrder.builder()
                .id(rs.getString("id"))
                .uid(DjfsUid.cons(rs.getLong("uid")))
                .build();
    };

    public PgBillingOrderDao(PgShardedDaoContext context) {
        super(context);
    }

    @Override
    public void insert(BillingOrder billingOrder) {
        throw new NotImplementedException();
    }

    @Override
    public void insert(ListF<BillingOrder> billingOrders) {
        throw new NotImplementedException();
    }

    @Override
    public ListF<BillingOrder> findAll(DjfsUid uid) {
        String sql = collectStats(uid) + " SELECT * FROM disk.billing_orders WHERE uid = :uid";
        return jdbcTemplate(DjfsUid.COMMON_UID).query(sql, M, Cf.map("uid", uid));
    }

    @Override
    public void deleteAll(DjfsUid uid) {
        String sql = collectStats(uid) + " DELETE FROM disk.billing_orders WHERE uid = :uid";
        jdbcTemplate(DjfsUid.COMMON_UID).update(sql, Cf.map("uid", uid));
    }
}
