package ru.yandex.chemodan.app.djfs.core.billing;

import org.bson.types.ObjectId;
import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDao;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author m-messiah
 */
public class PgBillingOrderHistoryDao extends PgShardedDao implements BillingOrderHistoryDao {
    private final static RowMapper<BillingOrderHistory> M = (rs, rowNum) -> {
        return BillingOrderHistory.builder()
                .id(new ObjectId(rs.getBytes("id")))
                .uid(DjfsUid.cons(rs.getLong("uid")))
                .build();
    };

    public PgBillingOrderHistoryDao(PgShardedDaoContext context) {
        super(context);
    }

    @Override
    public void insert(BillingOrderHistory billingOrderHistory) {
        throw new NotImplementedException();
    }

    @Override
    public void insert(ListF<BillingOrderHistory> billingOrdersHistory) {
        throw new NotImplementedException();
    }

    @Override
    public ListF<BillingOrderHistory> findAll(DjfsUid uid) {
        String sql = collectStats(uid) + " SELECT * FROM disk.billing_orders_history WHERE uid = :uid";
        return jdbcTemplate(DjfsUid.COMMON_UID).query(sql, M, Cf.map("uid", uid));
    }

    @Override
    public void deleteAll(DjfsUid uid) {
        String sql = collectStats(uid) + " DELETE FROM disk.billing_orders_history WHERE uid = :uid";
        jdbcTemplate(DjfsUid.COMMON_UID).update(sql, Cf.map("uid", uid));
    }
}
