package ru.yandex.chemodan.app.djfs.core.billing;

import com.mongodb.ReadPreference;
import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDao;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author m-messiah
 */
public class PgBillingServiceAttributeDao extends PgShardedDao implements BillingServiceAttributeDao {
    private final static RowMapper<BillingServiceAttribute> M = (rs, rowNum) -> {
        return BillingServiceAttribute.builder()
                .id(rs.getString("id"))
                .uid(DjfsUid.cons(rs.getLong("uid")))
                .amount(Option.ofNullable(rs.getLong("amount")))
                .v(Option.ofNullable(rs.getLong("v")))
                .build();
    };

    public PgBillingServiceAttributeDao(PgShardedDaoContext context) {
        super(context);
    }

    @Override
    public void insert(BillingServiceAttribute billingServiceAttribute) {
        throw new NotImplementedException();
    }

    @Override
    public void insert(ListF<BillingServiceAttribute> billingServiceAttribute) {
        throw new NotImplementedException();
    }

    @Override
    public ListF<BillingServiceAttribute> findAll(DjfsUid uid, Option<ReadPreference> readPreference) {
        String sql = collectStats(uid) + " SELECT * FROM disk.billing_service_attributes WHERE uid = :uid";
        return jdbcTemplate(DjfsUid.COMMON_UID).query(sql, M, Cf.map("uid", uid));
    }

    @Override
    public void deleteAll(DjfsUid uid) {
        String sql = collectStats(uid) + " DELETE FROM disk.billing_service_attributes WHERE uid = :uid";
        jdbcTemplate(DjfsUid.COMMON_UID).update(sql, Cf.map("uid", uid));
    }
}
