package ru.yandex.chemodan.app.djfs.core.billing;

import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDao;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author m-messiah
 */
public class PgBillingServiceAttributeHistoryDao extends PgShardedDao implements BillingServiceAttributeHistoryDao {
    private final static RowMapper<BillingServiceAttributeHistory> M = (rs, rowNum) -> {
        return BillingServiceAttributeHistory.builder()
                .id(rs.getString("id"))
                .uid(DjfsUid.cons(rs.getLong("uid")))
                .build();
    };

    public PgBillingServiceAttributeHistoryDao(PgShardedDaoContext context) {
        super(context);
    }

    @Override
    public void insert(BillingServiceAttributeHistory billingServiceAttributeHistory) {
        throw new NotImplementedException();
    }

    @Override
    public void insert(ListF<BillingServiceAttributeHistory> billingServiceAttributeHistory) {
        throw new NotImplementedException();
    }

    @Override
    public ListF<BillingServiceAttributeHistory> findAll(DjfsUid uid) {
        String sql = collectStats(uid) + " SELECT * FROM disk.billing_service_attributes_history WHERE uid = :uid";
        return jdbcTemplate(DjfsUid.COMMON_UID).query(sql, M, Cf.map("uid", uid));
    }

    @Override
    public void deleteAll(DjfsUid uid) {
        String sql = collectStats(uid) + " DELETE FROM disk.billing_service_attributes_history WHERE uid = :uid";
        jdbcTemplate(DjfsUid.COMMON_UID).update(sql, Cf.map("uid", uid));
    }
}
