package ru.yandex.chemodan.app.djfs.core.billing;

import com.mongodb.ReadPreference;
import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDao;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author m-messiah
 */
public class PgBillingServiceDao extends PgShardedDao implements BillingServiceDao {
    private final static RowMapper<BillingService> M = (rs, rowNum) -> {
        return BillingService.builder()
                .id(rs.getString("id"))
                .uid(DjfsUid.cons(rs.getLong("uid")))
                .pid(rs.getString("pid"))
                .v(Option.ofNullable(rs.getLong("v")))
                .build();
    };

    public PgBillingServiceDao(PgShardedDaoContext context) {
        super(context);
    }

    @Override
    public void insert(BillingService billingService) {
        String sql = collectStats(billingService.getUid())
                + " INSERT INTO disk.billing_services (id, uid, pid, v) "
                + "VALUES (?, ?, ?, ?)";

        jdbcTemplate(DjfsUid.COMMON_UID).update(
                sql, billingService.getId(), billingService.getUid(),
                billingService.getPid(), billingService.getV());
    }

    @Override
    public void insert(ListF<BillingService> billingService) {
        throw new NotImplementedException();
    }

    @Override
    public ListF<BillingService> findAll(DjfsUid uid, Option<ReadPreference> readPreference) {
        String sql = collectStats(uid) + " SELECT * FROM disk.billing_services WHERE uid = :uid";
        return jdbcTemplate(DjfsUid.COMMON_UID).query(sql, M, Cf.map("uid", uid));
    }

    @Override
    public void deleteAll(DjfsUid uid) {
        String sql = collectStats(uid) + " DELETE FROM disk.billing_services WHERE uid = :uid";
        jdbcTemplate(DjfsUid.COMMON_UID).update(sql, Cf.map("uid", uid));
    }
}
