package ru.yandex.chemodan.app.djfs.core.changelog;

import lombok.Builder;
import lombok.Data;
import org.bson.types.ObjectId;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.DjfsUidSource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.AntiVirusScanStatus;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourceType;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.MediaType;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.misc.enums.EnumResolver;

@Builder
@Data
public class Changelog implements DjfsUidSource {
    private final ObjectId id;
    private final long version;
    private final DjfsResourcePath path;
    private final DjfsResourceType resourceType;
    private final OperationType operationType;
    private final String fileId;
    private final boolean visible;
    private final boolean publik;

    @Builder.Default
    private final Option<String> groupId = Option.empty();

    @Builder.Default
    private final Option<String> groupPath = Option.empty();

    @Builder.Default
    private final Option<String> sha256 = Option.empty();

    @Builder.Default
    private final Option<String> md5 = Option.empty();

    @Builder.Default
    private final Option<Long> size = Option.empty();

    @Builder.Default
    private final Option<String> mimetype = Option.empty();

    @Builder.Default
    private final Option<MediaType> mediaType = Option.empty();

    @Builder.Default
    private final Option<AntiVirusScanStatus> antiVirusScanStatus = Option.empty();

    @Builder.Default
    private final Option<Boolean> hasPreview = Option.empty();

    @Builder.Default
    private final Option<Boolean> hasExternalSetprop = Option.empty();

    @Builder.Default
    private final Option<Instant> exifTime = Option.empty();

    @Builder.Default
    private final Option<Instant> modificationTime = Option.empty();

    @Builder.Default
    private final Option<Instant> dtime = Option.empty();

    @Builder.Default
    private final Option<DjfsResourcePath> newPath = Option.empty();

    @Override
    public DjfsUid getUid() {
        return path.getUid();
    }

    public enum OperationType {
        NEW,
        CHANGED,
        DELETED,
        MOVED,
        ;

        public static final EnumResolver<OperationType> R = EnumResolver.er(OperationType.class);
    }

}
