package ru.yandex.chemodan.app.djfs.core.changelog;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

import ru.yandex.chemodan.app.djfs.core.db.DaoProxyFactory;
import ru.yandex.chemodan.app.djfs.core.db.DjfsDbContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.db.mongo.MongoShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;

/**
 * @author eoshch
 */
@Configuration
@Import({
        DjfsDbContextConfiguration.class,
})
public class ChangelogContextConfiguration {
    @Bean
    public MongoChangelogDao mongoChangelogDao(MongoShardedDaoContext dependencies) {
        return new MongoChangelogDao(dependencies);
    }

    @Bean
    public PgChangelogDao pgChangelogDao(PgShardedDaoContext dependencies) {
        return new PgChangelogDao(dependencies);
    }

    @Bean
    @Primary
    public ChangelogDao changelogDaoProxy(DaoProxyFactory daoProxyFactory, MongoChangelogDao mongoDao,
            PgChangelogDao pgDao)
    {
        return daoProxyFactory.create(ChangelogDao.class, pgDao);
    }

    @Bean
    public ChangelogManager changelogManager(ChangelogDao changelogDao) {
        return new ChangelogManager(changelogDao);
    }

    @Bean
    public ChangelogEventHandler changelogEventHandler(ChangelogDao changelogDao, ChangelogManager changelogManager) {
        return new ChangelogEventHandler(changelogDao, changelogManager);
    }
}
