package ru.yandex.chemodan.app.djfs.core.changelog;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.djfs.core.db.Sharded;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
public interface ChangelogDao {
    @Sharded
    void insert(Changelog changelog);

    @Sharded
    void insert(DjfsUid uid, ListF<Changelog> changelogs);

    /**
     * Use in tests only!
     * Not ready for production!
     */
    @Sharded
    ListF<Changelog> findAll(DjfsUid uid);

    /**
     * Use in tests only!
     * Not ready for production!
     */
    @Sharded
    void deleteAll(DjfsUid uid);
}
